clc; clear;

% 시뮬레이션 파라미터
N = 50;  % 타임스텝
true_pos = linspace(0, 100, N);  % 실제 위치 (일직선 이동)
true_pos = [true_pos; true_pos]; % 2D 위치 (x = y)

% 센서 1 (예: GPS): 정밀도 낮음, 노이즈 큼
gps_noise = 5;
gps_meas = true_pos + gps_noise * randn(2, N);

% 센서 2 (예: IMU 기반 dead reckoning): 노이즈는 작지만 점차 drift
imu_drift = cumsum(0.3 * randn(2, N), 2);
imu_meas = true_pos + imu_drift;

% 센서 퓨전: 단순 평균
fused_pos = (gps_meas + imu_meas) / 2;

% 시각화
figure;
plot(true_pos(1,:), true_pos(2,:), 'k-', 'LineWidth', 2); hold on;
plot(gps_meas(1,:), gps_meas(2,:), 'ro--', 'LineWidth', 1);
plot(imu_meas(1,:), imu_meas(2,:), 'bo--', 'LineWidth', 1);
plot(fused_pos(1,:), fused_pos(2,:), 'g*-', 'LineWidth', 2);
legend('True Position', 'GPS Measurement', 'IMU Measurement', 'Fused Position');
xlabel('X Position'); ylabel('Y Position');
title('Simple Sensor Fusion: Averaging GPS and IMU');
grid on;
