% compare_CA_truth_CVvsCA_filters.m
clear; clc; rng(7);

%% Truth: Constant Acceleration (CA)
dt = 1.0; N = 50;
x0=0; v0=0; a0=0.3;
sig_j=0.05;               % jerk(모델) 노이즈
sig_gps=2.0;              % GPS 위치 노이즈
sig_imu=0.30;             % IMU 가속도 노이즈

A_ca = [1 dt 0.5*dt^2; 0 1 dt; 0 0 1];
G_ca = [dt^3/6; dt^2/2; dt];
x_true = zeros(3,N+1); x_true(:,1)=[x0; v0; a0];
for k=1:N
    j = sig_j*randn;
    x_true(:,k+1) = A_ca*x_true(:,k) + G_ca*j;
end
gps   = x_true(1,2:end) + sig_gps*randn(1,N);
imu_a = x_true(3,2:end) + sig_imu*randn(1,N);

%% Filter 1: CV KF (x=[p;v], z=GPS)
A_cv = [1 dt; 0 1]; G_cv=[0.5*dt^2; dt];
sig_a_cv = 0.20;                     % 튜닝(모델-미스매치 보정)
Q_cv = (sig_a_cv^2)*(G_cv*G_cv.');
H_cv=[1 0];  R_cv=sig_gps^2;

xhat_cv=zeros(2,N+1); Pcv=diag([10 1]);
for k=1:N
    xp=A_cv*xhat_cv(:,k);
    Pp=A_cv*Pcv*A_cv'+Q_cv;
    S=H_cv*Pp*H_cv'+R_cv; K=Pp*H_cv'/S;
    xhat_cv(:,k+1)=xp+K*(gps(k)-H_cv*xp);
    Pcv=(eye(2)-K*H_cv)*Pp;
end

%% Filter 2: CA KF (x=[p;v;a], z=[GPS; IMU a])
Q_ca=(sig_j^2)*(G_ca*G_ca.');
H_ca=[1 0 0; 0 0 1]; R_ca=diag([sig_gps^2, sig_imu^2]);

xhat_ca=zeros(3,N+1); Pca=diag([10 1 1]);
for k=1:N
    xp=A_ca*xhat_ca(:,k);
    Pp=A_ca*Pca*A_ca'+Q_ca;
    z=[gps(k); imu_a(k)];
    S=H_ca*Pp*H_ca'+R_ca; K=Pp*H_ca'/S;
    xhat_ca(:,k+1)=xp+K*(z-H_ca*xp);
    Pca=(eye(3)-K*H_ca)*Pp;
end

%% Metrics
pos_rmse_cv = sqrt(mean((x_true(1,2:end)-xhat_cv(1,2:end)).^2));
pos_rmse_ca = sqrt(mean((x_true(1,2:end)-xhat_ca(1,2:end)).^2));
vel_rmse_cv = sqrt(mean((x_true(2,2:end)-xhat_cv(2,2:end)).^2));
vel_rmse_ca = sqrt(mean((x_true(2,2:end)-xhat_ca(2,2:end)).^2));
fprintf('Position RMSE  CV=%.3f, CA=%.3f\n', pos_rmse_cv, pos_rmse_ca);
fprintf('Velocity RMSE  CV=%.3f, CA=%.3f\n', vel_rmse_cv, vel_rmse_ca);

%% Plots
t=0:dt:N; tM=1:N;
figure
subplot(211)
plot(t, x_true(1,:), 'k','LineWidth',1.6); hold on;
plot(tM, gps,'ro','MarkerSize',4);
plot(tM, xhat_cv(1,2:end),'b--','LineWidth',1.6);
plot(tM, xhat_ca(1,2:end),'g-','LineWidth',1.8);
grid on; xlabel('Time Step'); ylabel('Position');
title('CA Truth: Position, CV vs CA Kalman');
legend('True','GPS','CV KF','CA KF','Location','NorthWest');

subplot(212)
plot(t, x_true(2,:), 'k','LineWidth',1.6); hold on;
plot(tM, xhat_cv(2,2:end),'b--','LineWidth',1.6);
plot(tM, xhat_ca(2,2:end),'g-','LineWidth',1.8);
grid on; xlabel('Time Step'); ylabel('Velocity');
title('CA Truth: Velocity, CV vs CA Kalman');
legend('True','CV KF','CA KF','Location','NorthWest');
